#ifndef __CExponentParameter__
#define __CExponentParameter__

#include "CParameter.hpp"
using Exponent::MathTools::CParameter;

//	===========================================================================

namespace Exponent
{
	namespace MathTools
	{
		/**
		 * @class CExponentParameter CExponentParameter.hpp
		 * @brief Maps a 0 - 1.0 double to a new range with exponential mapping
		 *
		 * @date 13/11/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CExponentParameter.hpp,v 1.3 2007/02/08 21:06:44 paul Exp $
		 */
		class CExponentParameter : public CParameter
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 */
			CExponentParameter();

			/**
			 * Constructor MIN MUST BE > 0.0
			 * @param min The min value - MUST BE > 0.0
			 * @param max The max value
			 * @param value The value to convert
			 */
			CExponentParameter(const double min, const double max, const double value);

			/**
			 * Destruction
			 */
			virtual ~CExponentParameter();

//	===========================================================================

			/**
			 * Set the range to map to
			 * @param min The min value - MUST BE > 0.0
			 * @param max The max value
			 */
			virtual void setRange(const double min, const double max);

			/**
			 * Set the value
			 * @param value The value to convert
			 */
			virtual void setValue(const double value);

//	===========================================================================

		protected:

//	===========================================================================

			double m_logOut;				/**< Log output value */
			double m_logMin;				/**< log(min) */
			double m_logMax;				/**< log(max) */
			double m_logData;				/**< Log output */
			double m_logDifference;			/**< log(max)-log(min) */
		};
	}
}
#endif	// End of CExponentParameter.hpp